#include "stdafx.h"
#include "Particles.h"
#include "utilities.h"

bool IsNodeRwParticle(INode *node)
{
    if (node->GetObjectRef()->ClassID()==RWPARTICLE_CLASS_ID) {
        return true;
    }
    else {
        return false;
    }
}

bool ExportRwParticle(INode *node, RwMatrix *matrix, RpClump *clump, RwFrame *frame,
                      float ScaleFactor, WarningList *warnings)
{
	RwParticle	*rwParticle;
	TimeValue	tSampleTime = 0;	//We allow no Max animation at present, so just grab everything at time 0
    RpAtomic *atomic;
    RwFrame *frameAtomic;
    RpMaterial *material;
    RwV3d fForce = {0.0f, 0.0f, 0.0f};
    RwRGBA startCol, endCol;

	TimeValue	tLifeTime;
	float		fMinSpeed, fMaxSpeed;
	float		fEmitterWidth, fEmitterHeight;
	float		fAngle, fDamping;
	int			nParticleCount;
	float		fStartSize, fGrowth, fAspectRatio;
	Color		cStartCol, cEndCol;
	float		fStartAlpha, fEndAlpha;
	Interval	iValid;

	//Check that it really is a particle, otherwise return false and flag the error
	if (node->GetObjectRef()->ClassID()!=RWPARTICLE_CLASS_ID)
	{
		warnings->add(CWarning(wtError,node->GetName(),
            "Node is not a particle system"));
        return FALSE;
	}

	//Get the particle object
	rwParticle = (RwParticle *)node->GetObjectRef();

	rwParticle->pbSpawnRollout->GetValue(plPARTICLECOUNT,tSampleTime,nParticleCount,FOREVER);
	rwParticle->pbSpawnRollout->GetValue(plFORCEX,tSampleTime,fForce.x,FOREVER);
	rwParticle->pbSpawnRollout->GetValue(plFORCEY,tSampleTime,fForce.y,FOREVER);
    rwParticle->pbSpawnRollout->GetValue(plFORCEZ,tSampleTime,fForce.z,FOREVER);
	rwParticle->pbSpawnRollout->GetValue(plPARTICLELIFETIME,tSampleTime,tLifeTime,FOREVER);
	rwParticle->pbSpawnRollout->GetValue(plPARTICLEMINSPEED,tSampleTime,fMinSpeed,FOREVER);
	rwParticle->pbSpawnRollout->GetValue(plPARTICLEMAXSPEED,tSampleTime,fMaxSpeed,FOREVER);
	rwParticle->pbSpawnRollout->GetValue(plEMITTERWIDTH,tSampleTime,fEmitterWidth,FOREVER);
	rwParticle->pbSpawnRollout->GetValue(plEMITTERHEIGHT,tSampleTime,fEmitterHeight,FOREVER);
	rwParticle->pbSpawnRollout->GetValue(plPARTICLEANGLE,tSampleTime,fAngle,FOREVER);
	rwParticle->pbSpawnRollout->GetValue(plPARTICLEDAMPING,tSampleTime,fDamping,FOREVER);

	rwParticle->pbRenderRollout->GetValue(plPARTICLESIZE,tSampleTime,fStartSize,FOREVER);
	rwParticle->pbRenderRollout->GetValue(plRENDERGROWTH,tSampleTime,fGrowth,FOREVER);
	rwParticle->pbRenderRollout->GetValue(plRENDERASPECTRATIO,tSampleTime,fAspectRatio,FOREVER);
	rwParticle->pbRenderRollout->GetValue(plCOLOURSTARTCOL,tSampleTime,cStartCol,FOREVER);
	rwParticle->pbRenderRollout->GetValue(plCOLOURSTARTALPHA,tSampleTime,fStartAlpha,FOREVER);
	rwParticle->pbRenderRollout->GetValue(plCOLOURENDCOL,tSampleTime,cEndCol,FOREVER);
	rwParticle->pbRenderRollout->GetValue(plCOLOURENDALPHA,tSampleTime,fEndAlpha,FOREVER);

    //Rescale the emitter and the particle size
    fEmitterWidth*=ScaleFactor;
    fEmitterHeight*=ScaleFactor;
    fStartSize*=ScaleFactor;
    //even the velocities need to be rescaled as all the distances have changed
    fMinSpeed*=ScaleFactor;
    fMaxSpeed*=ScaleFactor;
    //and the force as it's Kgm/s^2
    fForce.x*=ScaleFactor;
    fForce.y*=ScaleFactor;
    fForce.z*=ScaleFactor;
    
    //The particle system will only render if it has a texture.
    //The texture is contained in the diffuse bitmap attached to the emitter.
    //finally, get the meterial for the first face, assuming all faces equal
    material=Max2RpMaterial(node->GetMtl(), rwParticle->mesh.getFaceMtlIndex(0), 0);
    if (!material)
    {
        //generate an error
        warnings->add(CWarning(wtError,node->GetName(),
            "No diffuse bitmap texture defined on particle emitter node"));
    }

    //now create a particle system
    atomic = RpParticlesAtomicCreate(nParticleCount, material);
    if (!atomic)
    {
        warnings->add(CWarning(wtError,node->GetName(),
            "Failed to create a particle system atomic"));
        return FALSE;
    }

    frameAtomic = RpAtomicGetFrame(atomic);        
    RwFrameAddChild(frame, frameAtomic);                    
    RpClumpAddAtomic(clump, atomic);
	
	RpParticlesAtomicSetFlightTime(atomic, TicksToSec(tLifeTime));
	RpParticlesAtomicSetEmitterSize(atomic, fEmitterWidth, fEmitterHeight);
    fAngle *= 90.0f / PI;
	RpParticlesAtomicSetEmitterAngle(atomic, fAngle);
	RpParticlesAtomicSetSpeed(atomic, fMinSpeed, fMaxSpeed, fDamping);
	RpParticlesAtomicSetForce(atomic, &fForce);
    RpParticlesAtomicSetSize(atomic, fStartSize, fGrowth, fAspectRatio);
    
    startCol.red = (RwReal)(cStartCol.r * 255.0f);
    startCol.green = (RwReal)(cStartCol.g * 255.0f);
    startCol.blue = (RwReal)(cStartCol.b * 255.0f);
    startCol.alpha = (RwReal)((fStartAlpha + 0.001) * 100.0f);
    
    endCol.red = (RwReal)(cEndCol.r * 255.0f);
    endCol.green = (RwReal)(cEndCol.g * 255.0f);
    endCol.blue = (RwReal)(cEndCol.b * 255.0f);
    endCol.alpha = (RwReal)((fEndAlpha + 0.001) * 100.0f);
   
    RpParticlesAtomicSetColors(atomic, &startCol, &endCol);

	return TRUE;
}